# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Deleting model 'Settings'
        db.delete_table('main_settings')

        # Deleting field 'UserMonths.id'
        db.delete_column('main_usermonths', 'id')


        # Renaming column for 'UserMonths.user_id' to match new field type.
        db.rename_column('main_usermonths', 'user_id', 'user_id_id')
        # Changing field 'UserMonths.user_id'
        db.alter_column('main_usermonths', 'user_id_id', self.gf('django.db.models.fields.related.ForeignKey')(primary_key=True, to=orm['auth.User']))
        # Adding index on 'UserMonths', fields ['user_id']
        db.create_index('main_usermonths', ['user_id_id'])

        # Adding unique constraint on 'UserMonths', fields ['user_id']
        db.create_unique('main_usermonths', ['user_id_id'])


        # Renaming column for 'UserMonths.month' to match new field type.
        db.rename_column('main_usermonths', 'month', 'month_id')
        # Changing field 'UserMonths.month'
        db.alter_column('main_usermonths', 'month_id', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['main.Month']))
        # Adding index on 'UserMonths', fields ['month']
        db.create_index('main_usermonths', ['month_id'])


    def backwards(self, orm):
        # Removing index on 'UserMonths', fields ['month']
        db.delete_index('main_usermonths', ['month_id'])

        # Removing unique constraint on 'UserMonths', fields ['user_id']
        db.delete_unique('main_usermonths', ['user_id_id'])

        # Removing index on 'UserMonths', fields ['user_id']
        db.delete_index('main_usermonths', ['user_id_id'])

        # Adding model 'Settings'
        db.create_table('main_settings', (
            ('value', self.gf('django.db.models.fields.TextField')()),
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('key', self.gf('django.db.models.fields.CharField')(max_length=200)),
        ))
        db.send_create_signal('main', ['Settings'])

        # Adding field 'UserMonths.id'
        db.add_column('main_usermonths', 'id',
                      self.gf('django.db.models.fields.AutoField')(default=1, primary_key=True),
                      keep_default=False)


        # Renaming column for 'UserMonths.user_id' to match new field type.
        db.rename_column('main_usermonths', 'user_id_id', 'user_id')
        # Changing field 'UserMonths.user_id'
        db.alter_column('main_usermonths', 'user_id', self.gf('django.db.models.fields.IntegerField')())

        # Renaming column for 'UserMonths.month' to match new field type.
        db.rename_column('main_usermonths', 'month_id', 'month')
        # Changing field 'UserMonths.month'
        db.alter_column('main_usermonths', 'month', self.gf('django.db.models.fields.IntegerField')())

    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'main.month': {
            'Meta': {'object_name': 'Month'},
            'discs': ('django.db.models.fields.CharField', [], {'max_length': '500'}),
            'number': ('django.db.models.fields.IntegerField', [], {'primary_key': 'True'})
        },
        'main.prediction': {
            'Meta': {'object_name': 'Prediction', 'db_table': "'sphere`.`main_prediction'", 'managed': 'False'},
            'audio': ('django.db.models.fields.files.FileField', [], {'max_length': '100', 'null': 'True', 'blank': 'True'}),
            'category_id': ('django.db.models.fields.IntegerField', [], {}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'index1': ('django.db.models.fields.IntegerField', [], {}),
            'index2': ('django.db.models.fields.IntegerField', [], {}),
            'text': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'})
        },
        'main.usermonths': {
            'Meta': {'object_name': 'UserMonths'},
            'month': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['main.Month']"}),
            'user_id': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'month'", 'primary_key': 'True', 'to': "orm['auth.User']"})
        }
    }

    complete_apps = ['main']