﻿# -*- coding:utf-8 -*-
from django.db import models
from django.utils import simplejson
from discs.settings import *
from django.contrib.auth.models import User

MONTHS_CHOICES = (
	(1, 1),
	(2, 2),
	(3, 3),
	(4, 4),
	(5, 5),
	(6, 6),
	(7, 7),
	(8, 8),
	(9, 9),
	(10, 10),
)


class Prediction(models.Model):
	id = models.AutoField(primary_key=True)
	category_id = models.IntegerField(verbose_name="id категории")
	index1 = models.IntegerField(verbose_name="Диск №")
	index2 = models.IntegerField(verbose_name="Дом №")
	text = models.TextField(verbose_name="Текст", null=True, blank=True)
	audio = models.FileField(upload_to="audio", null=True, blank=True)

	class Meta:
		managed = False
		db_table = SIBLING_DB + '`.`main_prediction'
		verbose_name = "Предсказание"
		verbose_name_plural = "Предсказания"

	def __unicode__(self):
		return self.text


class Month(models.Model):
	class Meta:
		verbose_name = "Месяц обучения"
		verbose_name_plural = "Месяцы обучения"
	number = models.IntegerField(choices=MONTHS_CHOICES, verbose_name="Месяц обучения", primary_key=True)
	discs = models.CharField(max_length=500, verbose_name="Разрешённые диски", editable=False)

	@property
	def alowed(self):
		return [val.strip() for val in self.discs.split(',')]

	def __unicode__(self):
		return u'%d месяц' % self.number
		

class UserMonths(models.Model):
	user_id = models.OneToOneField(User, verbose_name="id пользователя", related_name='month', primary_key=True)
	month = models.ForeignKey(Month, verbose_name="Месяц обучения")
	
	class Meta:
		verbose_name = "Месяц обучения пользователей"
		verbose_name_plural = "Месяцы обучения пользователей"
