# -*- coding:utf-8 -*-
from django.contrib.auth.decorators import login_required
from django.contrib.auth.models import User
from django.shortcuts import render_to_response, redirect
from django.core.context_processors import csrf
from django.http import Http404, HttpResponse
from django.core.paginator import Paginator, EmptyPage, PageNotAnInteger
from django.db.models import Q
from django.core.mail import send_mail
from django.contrib.auth.views import login as auth_login

from discs.main.models import *
from discs.main.utils import get_disc_numbers
from discs.settings import *


def commonWrapper(func, *args, **kwargs):
	def wrapFunction(request, *args, **kwargs):
		c = {}
		c.update(csrf(request))
		c['request'] = request
				
		return func(request, c, *args, **kwargs)
	return wrapFunction

@commonWrapper
def home(request, c):
	if request.POST:
		try:
			prediction = Prediction.objects.get(category_id = SIBLING_CATEGORY_ID,
											index1 = request.POST['disc_num'],
											index2 = request.POST['disc_pos'])
			audio = prediction.audio.url
		except:
			audio = False
			
		c= {}
		c["SIBLING_MEDIA_URL"] = SIBLING_MEDIA_URL
		c['audio'] = audio

		return render_to_response("prediction_ajax_response.html", c)

	c['discs_positions_range'] = range(1, 13) + range(-1,-13,-1)
	
	disc_numbers = get_disc_numbers()
	
	if(request.user.is_active and not request.user.is_staff):
		alowed_discs = []
		try:
			for value in request.user.month.month.alowed:
				try:
					value = int(value)
				except: pass

				try:
					alowed_discs.append([(num, val) for (num, val) in disc_numbers if value == val][0])
				except: pass
				
		except UserMonths.DoesNotExist:
			pass
	else:
		alowed_discs = disc_numbers
	
	c["discs_"]=alowed_discs
	

	return render_to_response("home.html", c)

	
@commonWrapper
def showContent(request, c, keyphrase):
	if keyphrase == "how":
		return render_to_response("how.html", c)
	if keyphrase == "about":
		return render_to_response("about.html", c)
	if keyphrase == "private":
		return render_to_response("private.html", c)
	if keyphrase == "study":
		return render_to_response("study.html", c)
	if keyphrase == "contacts":
		return render_to_response("contacts.html", c)


@commonWrapper
@login_required
def superadmin(request, c):
	if request.POST:
		post=request.POST
		allow_dict = {}
		for key, value in post.items():
			if key.find("month")!=-1:
				allow_dict[key[6:]]=value
		if allow_dict.__len__():
			setting=Settings.objects.get(key="discs_alowed")
			setting.push(allow_dict)
			c["alowed_settings"]=allow_dict
	if not c.get("alowed_settings"):
		c["alowed_settings"]=Settings.objects.get(key="discs_alowed").unpack()
	c["months_table"]=[];
	for index in range(10):
		try:
			c["months_table"].append(c["alowed_settings"][str(index+1)])
		except:
			c["months_table"].append(0);
	
	return render_to_response("superadmin.html", c)


@commonWrapper
@login_required
def mailing(request, c):
	if not request.user.is_staff:
		return redirect(home)

	if request.POST:
		post = request.POST
		if post.get("subject") and post.get("text") and post.get("ids"):
			ids = post['ids'].split(",")
			for id in ids:
				try:
					user = User.objects.get(id = id)
					send_mail(post.get("subject"), post.get("text"), 'info@syncronet.ru', [user.email,], fail_silently=False)
				except:
					pass
			c['message'] = "Почта отправлена"

	c['users'] = User.objects.all()
	return render_to_response("mailing.html", c)


def login(request):
	redirect_field_name = 'next'
	if not request.POST.get("next", "").find("logout") == -1:
		redirect_field_name = 'fake'
	return auth_login(request, redirect_field_name=redirect_field_name)