# -*- coding:utf-8 -*-
from discs.main.models import *
from django.contrib import admin
from django.contrib.auth.models import User

class UserMonthsAdmin(admin.ModelAdmin):
	def user_name(self, item):
		return item.user_id.username

	user_name.short_description = 'Имя пользователя'
	list_display = ("user_name", "month")
	list_filter=("user_id", "month")
	list_display_links = ('month',)
	fields = ("user_id", "month")

class MonthAdmin(admin.ModelAdmin):
	from discs.main.forms import MonthAdminForm
	form = MonthAdminForm
	list_display = ('number', 'discs',)
	ordering = ('number',)

admin.site.register(UserMonths, UserMonthsAdmin)
admin.site.register(Month, MonthAdmin)
