# -*- coding:utf-8 -*-
from django.conf import settings
from django.contrib.sites.models import RequestSite, Site
from registration import signals
from registration.forms import RegistrationForm
from registration.models import RegistrationProfile
from discs.main.models import UserMonths, Month
from django.core.mail import send_mail, EmailMultiAlternatives
from django.template.loader import render_to_string

def notify_admin(sender, **kwargs):
	email_vars = {
		'user': kwargs['user'],
		'month': UserMonths.objects.get(user_id=kwargs['user'].id)
	}
	text_content = render_to_string('new_user_notification_email.txt', email_vars)
	html_content = render_to_string('new_user_notification_email.html', email_vars)

	msg = EmailMultiAlternatives("Зарегистрирован новый пользователь", text_content,
								settings.DEFAULT_FROM_EMAIL, settings.MODERATOR_EMAIL)
	msg.attach_alternative(html_content, "text/html")
	msg.send()

class CustomBackend(object):
	def register(self, request, **kwargs):
		"""
		Given a username, email address and password, register a new
		user account, which will initially be inactive.

		Along with the new ``User`` object, a new
		``registration.models.RegistrationProfile`` will be created,
		tied to that ``User``, containing the activation key which
		will be used for this account.

		An email will be sent to the supplied email address; this
		email should contain an activation link. The email will be
		rendered using two templates. See the documentation for
		``RegistrationProfile.send_activation_email()`` for
		information about these templates and the contexts provided to
		them.

		After the ``User`` and ``RegistrationProfile`` are created and
		the activation email is sent, the signal
		``registration.signals.user_registered`` will be sent, with
		the new ``User`` as the keyword argument ``user`` and the
		class of this backend as the sender.

		"""
		username, email, password = kwargs['username'], kwargs['email'], kwargs['password1']
		if Site._meta.installed:
			site = Site.objects.get_current()
		else:
			site = RequestSite(request)
		new_user = RegistrationProfile.objects.create_inactive_user(username, email,
																	password, site)
		signals.user_registered.send(sender=self.__class__,
									 user=new_user,
									 request=request)
	
		signals.user_activated.connect(notify_admin)
		month = Month.objects.get(pk=int(kwargs['month']))
		
		#TODO use objects.create
		user_month = UserMonths(user_id=new_user, month=month)
		user_month.save()
		
		return new_user
	
	def registration_allowed(self, request):
		"""
		Indicate whether account registration is currently permitted,
		based on the value of the setting ``REGISTRATION_OPEN``. This
		is determined as follows:

		* If ``REGISTRATION_OPEN`` is not specified in settings, or is
		  set to ``True``, registration is permitted.

		* If ``REGISTRATION_OPEN`` is both specified and set to
		  ``False``, registration is not permitted.
		
		"""
		return getattr(settings, 'REGISTRATION_OPEN', True)
	
	def post_registration_redirect(self, request, user):
		"""
		Return the name of the URL to redirect to after successful
		user registration.
		"""
		return ('registration_complete', (), {})

	