# -*- coding:utf-8 -*-
from registration.forms import RegistrationFormUniqueEmail
from django import forms
from discs.main.models import Month
from discs.main.utils import get_disc_numbers
from django.contrib.admin.widgets import FilteredSelectMultiple


class customRegForm(RegistrationFormUniqueEmail):
	choices = (
		('1', '1'),
		('2', '2'),
		('3', '3'),
		('4', '4'),
		('5', '5'),
		('6', '6'),
		('7', '7'),
		('8', '8'),
		('9', '9'),
		('10', '10'),
	)

	month = forms.ChoiceField(choices=choices,
							label="Месяц обучения",
							widget=forms.Select(attrs={'class':'styled'}))
	
	def __init__(self, *args, **kw):
		super(RegistrationFormUniqueEmail, self).__init__(*args, **kw)
		self.fields.keyOrder = [
			'username',
			'email',
			'month',
			'password1',
			'password2']


class MonthAdminForm(forms.ModelForm):
	class Meta:
		model = Month
		readonly_fields = ('discs',)
	disc_select = forms.MultipleChoiceField(choices=get_disc_numbers(all_virtual=True),
			widget=FilteredSelectMultiple(u"Номера дисков", is_stacked=False),
			required=False,
			label='Номера дисков')
	def __init__(self, *args, **kwargs):
		if kwargs.get('instance'):
			self.base_fields['disc_select'].initial = kwargs['instance'].discs.split(',')
		super(MonthAdminForm, self).__init__(*args, **kwargs)
	
	def save(self, *args, **kwargs):
		commit = kwargs.pop('commit', True)
		instance = super(MonthAdminForm, self).save(*args, commit = False, **kwargs)
		instance.discs = ','.join(self.cleaned_data['disc_select'])
		if commit:
			instance.save()
		return instance
